/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.evil;

import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.content.complex.ListTickingToken;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.l2damagetracker.contents.curios.L2Totem;
import dev.xkmc.l2damagetracker.contents.curios.TotemUseToClient;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EvilSpiritWalk
extends ITokenProviderItem<Data>
implements L2Totem {
    private static final AttrAdder MAGIC = AttrAdder.of("evil_spirit_walk", () -> ((RegistryEntry)L2DamageTracker.MAGIC_FACTOR).get(), AttributeModifier.Operation.ADDITION, EvilSpiritWalk::getMagic);
    private static final AttrAdder ATK = AttrAdder.of("evil_spirit_walk", () -> Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE, EvilSpiritWalk::getAtk);

    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.evil.evilSpiritWalkRealityIndex.get();
    }

    public static double getAtk() {
        return (Double)CoPConfig.COMMON.evil.evilSpiritWalkAtkBonus.get();
    }

    public static double getMagic() {
        return (Double)CoPConfig.COMMON.evil.evilSpiritWalkMagicBonus.get();
    }

    private static int getCD() {
        return (Integer)CoPConfig.COMMON.evil.evilSpiritWalkCoolDown.get();
    }

    public EvilSpiritWalk(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= EvilSpiritWalk.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(EvilSpiritWalk.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Evil.WALK.get((int)Math.round(EvilSpiritWalk.getMagic() * 100.0), (int)Math.round(EvilSpiritWalk.getAtk() * 100.0), (int)Math.round((double)EvilSpiritWalk.getCD() / 20.0)).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_36335_().m_41519_((Item)this)) {
            return;
        }
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)EvilSpiritWalk.getIndexReq()) {
            super.tick(player);
        }
    }

    public boolean allow(LivingEntity self, DamageSource source) {
        if (!(self instanceof Player)) {
            return false;
        }
        Player player = (Player)self;
        if (!((ConditionalData)ConditionalData.HOLDER.get(player)).hasData(this.getKey())) {
            return false;
        }
        return !player.m_36335_().m_41519_((Item)this);
    }

    public void trigger(LivingEntity self, ItemStack holded, Consumer<ItemStack> second) {
        if (!(self instanceof Player)) {
            return;
        }
        Player player = (Player)self;
        L2DamageTracker.PACKET_HANDLER.toTrackingPlayers((SimplePacketBase)new TotemUseToClient((Entity)player, holded), (Entity)player);
        self.m_21153_(self.m_21233_());
        self.m_21219_();
        self.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
        self.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
        self.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
        player.m_36335_().m_41524_((Item)this, EvilSpiritWalk.getCD());
    }

    @SerialClass
    public static class Data
    extends ListTickingToken {
        public Data() {
            super(List.of(MAGIC, ATK));
        }

        @Override
        protected void removeImpl(Player player) {
            super.removeImpl(player);
            player.m_21195_((MobEffect)CoPEffects.SPIRIT_WALK.get());
        }

        @Override
        protected void tickImpl(Player player) {
            super.tickImpl(player);
            EffectUtil.refreshEffect((LivingEntity)player, (MobEffectInstance)new MobEffectInstance((MobEffect)CoPEffects.SPIRIT_WALK.get(), 40, 0, true, true), (EffectUtil.AddReason)EffectUtil.AddReason.SKILL, (Entity)player);
        }
    }
}

